define(['angular', 'app', 'TrackersFHIRService'], function (angular, app) {
    'use strict';

    app.service('BpPulseFHIRService', function (TrackersFHIRService) {
        var emptyBpPulseResource = {
            meta: {
                tag: [
                    {
                        'system': 'https://wiki.mobilehealth.DOMAIN.EXT/display/PGDMS/Client+Provenance+Mapping',
                        'code': 'REDACTED',
                        'display': 'VA FitHeart'
                    }
                ],
            },
            code: {coding: [{'system': 'http://loinc.org','code': '8716-3','display': 'Vital Signs'}]},
            component: [
                {
                    code: {coding: [{system: 'http://loinc.org',code: '8480-6',display: 'Systolic blood pressure'}]},
                    valueQuantity: {unit: 'mm[Hg]'}
                },
                {
                    code: {coding: [{system: 'http://loinc.org',code: '8462-4',display: 'Diastolic blood pressure'}]},
                    valueQuantity: {unit: 'mm[Hg]'}
                },
                {
                    code: {coding: [{system: 'http://loinc.org',code: '8867-4',display: 'Heart rate'}]},
                    valueQuantity: {unit: 'bpm'}
                }
            ]
        };

        var positions = {
            Standing: {code: {coding: [{system: 'http://loinc.org',code: '69001-6',display: 'Heart rate --standing'}]},
                valueString: 'Standing'
            },
            Sitting: {code: {coding: [{system: 'http://loinc.org',code: '69000-8', display: 'Heart rate --sitting'}]},
                valueString: 'Sitting'
            },
            Lying: {code: {coding: [{system: 'http://loinc.org', code: '68999-2', display: 'Heart rate --supine'}]},
                valueString: 'Lying'
            }
        }

        return angular.extend({}, angular.copy(TrackersFHIRService), {
            code: 'http://loinc.org|8716-3',
            supportsLatest: true,

            buildResource: function (ngModel) {
                TrackersFHIRService.buildResource(ngModel);

                if (ngModel.method) {
                    ngModel.component[3] = positions[ngModel.method];
                    ngModel.method = undefined;
                } else if (ngModel.component[3]) {
                    // remove position if it's been unset
                    ngModel.component = ngModel.component.splice(0, 3);
                    ngModel.method = undefined;
                }

                ngModel.component = ngModel.component.map(function (item) {
                    // convert string numbers back to regular int
                    if (item.hasOwnProperty('valueQuantity')) {
                        item.valueQuantity.value = parseInt(item.valueQuantity.value);
                    }
                    return item;
                });

                return ngModel;
            },

            createEmpty: function () {
                var emptyResource = angular.copy(emptyBpPulseResource);

                return angular.extend({}, TrackersFHIRService.createEmpty(), emptyResource);
            },

            transformItem: function (item) {
                TrackersFHIRService.transformItem(item);

                if (item.component[3]) {
                    item.method = item.component[3].valueString;
                }
            }
        });
    });
});